//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: UART transmit/receive example : transmit(TX) within polling, receive(RX) within interrupt(RX)
//******************************************
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"
#include "6812_REG_bit_V2.h"

		uint	count1;
		uchar	send1;

		uchar	receive_flag;

		extern	unsigned char uart_flag,RX_DATA;






unsigned char TX_DATA;
void main()
{
	WDCDR.byte = 0x4e;	//clear WDT
    //=========================
	//set UART pin
	// 
	//=========================
	P9CR.bit.b1 = 0x0;  //set P91 as input pin
	P9CR.bit.b0 = 0x1;	//set P90 as output pin
	P9FC.bit.b0 = 0x1;  //set P90 as special function pin
	UATCNG.bit.b1 = 0;  //set P90 to TX and P91 to RX
    //=========================
	//set IntRXD  IntTXD
	// 
	//=========================	
	__asm("DI");
	POFFCR1.byte = 0x02;	//[-,-,-,SBI0EN,	-,-,UART1EN,-]
	EIRE.byte = 0xC0;// [INTTXD1,INTRXD1,-,INT4	   INT3,INT2,-,-]
	__asm("EI");
	
		
	UART1CR2.byte=0x20;	//RTSEL : 17 clocks , receive stop bit length : 1 bit
//	UART1DR.byte = 0x01;	//baud rate = 115200
	UART1DR.byte = 24;	//baud rate = 9600
	UART1CR1.byte = 0xc0;	//
	
	send1=0;
	 receive_flag=0; 
	 
	 
	 
	 
	while(1)
	{	 
	 
	 
	 
	 while(receive_flag==0)clr_wdt;
	 
		 receive_flag=0; 
 

		//===========================
		// UART transmission example 
		//===========================
	//	while(UART1SR.bit.b1==1)	//b1 ==1 UARTon transmitting   b1 == 0 UARTbefore transmission or end of transmission
	//	{
	//		WDCDR.byte = 0x4e;	//clear wdt
	//	}
		
		TX_DATA = RX_DATA;	//send1++;			//user define data
		
		
		TD1BUF.byte = TX_DATA;  //send the data which just receive

		
		for(count1=0;count1<5000;clr_wdt)count1++;

		//===========================
		// you will get the TX data in the interrupt subroutine IntRXD1
		//===========================		
		
		
	}	
	
}

